/**********************************************************************
*
* lister file.c -- Version 3.0
*
* Developer Technical Support Apple II Sample Code
*
* Copyright (c)
* Apple Computer, Inc.  1990
* All Rights Reserved.
*
* Written by Eric Soldan.
*
* This file contains the code which handles the file IO for lister.
* The file IO for lister is relatively simple.  All it has to do
* is to open a file and read in lines of characters.  In spite of
* the simplicity of the file IO needs of lister, this code has been
* written in a general way so that multiple files can be opened at
* a time by using this code.  All you need to use this code is a
* file IO structure.  Once you have this set up with all the 
* default behaviors defined, you can start using these routines.
*
**********************************************************************/

#include <types.h>
#include <memory.h>
#include <stdfile.h>
#include <misctool.h>

#define __file__ 1
#include "lister.h"

/**********************************************************************/

/* This routine is a simple front-end to SFGetFile2, and has
** supporting code for setting up info in the file IO structure
** so the other routines can have fun, too.
*/

unsigned int    getFileName(file, dx, dy, promptStr, filterProc, typeList)
FileIO          *file;
unsigned int    dx, dy;
unsigned long   filterProc, typeList;
char            *promptStr;
{
    SFReplyRec2     myReply;

    zapLocals();

    myReply.nameRefDesc = myReply.pathRefDesc = refIsNewHandle;
    SFGetFile2(                 /* Do an incredibly ordinary SFGetFile2. */
        dx, dy,
        refIsPointer,
        promptStr,
        filterProc,
        typeList,
        &myReply
    );

    if (myReply.good) {         /* User did pick something... */

        if (file->pathRef) DisposeHandle(file->pathRef);
        if (file->nameRef) DisposeHandle(file->nameRef);
            /* Dispose the old SFGetFile2 ref handles, since we */
            /* have new ones to play with.                      */

        file->pathRef = (char **)myReply.pathRef;
        file->nameRef = (char **)myReply.nameRef;
            /* Record the new ones. */

    }
    else {      /* User cancelled, so we don't want these handles. */
        DisposeHandle(myReply.pathRef);
        DisposeHandle(myReply.nameRef);
    }
}

/**********************************************************************/

void            spreadTheWord(file, theRefNum)
FileIO          *file;
unsigned int    theRefNum;
{
    /* We want the file refNum in all the structures that may be used. */

    file->close.refNum     =
    file->newline.refNum   =
    file->readWrite.refNum =
    file->getPos.refNum    =
    file->setPos.refNum    =
        theRefNum;
}

/**********************************************************************/

unsigned int    openFile(file)
FileIO          *file;
{
    if (!file->pathRef) return(_fileErr = 0xFFFF);
        /* We can't open what we don't have. */

    HLock(file->pathRef);                   /* Lock down the file name. */
    file->open.pathname = (GSString255 *)(*file->pathRef + 2);
                                            /* Class 1 str. from SFGetFile2. */

    OpenGS(&file->open);                    /* Open the file. */
    _fileErr = _toolErr;
    HUnlock(file->pathRef);
    if (_fileErr) return(_fileErr);

    spreadTheWord(file, file->open.refNum);

    NewlineGS(&file->newline);              /* Set how lines are to be read. */
    if (_fileErr = _toolErr) {
        CloseGS(&file->close);
        spreadTheWord(file, 0);
        return(_fileErr);                   /* We had a problem. */
    }

    return(0);                              /* _fileErr = 0 also. */
}

/**********************************************************************/

unsigned int    readFile(file)
FileIO          *file;
{
    ReadGS(&file->readWrite);
    _fileErr = _toolErr;
    line[file->readWrite.transferCount] = '\0';
    return(file->readWrite.transferCount);
}

/**********************************************************************/

unsigned int    closeFile(file)
FileIO          *file;
{
    /* Note that this routines does not dispose of the SFGetFile2
    ** ref handles.  Just because the file is closed doesn't mean
    ** that the application is done with the file name.  It is up
    ** to the application to dispose of these handles if they are
    ** no longer needed or wanted.  After disposing of the handles,
    ** it is important to set them to NULL so that other routines
    ** know that there isn't a current file name.
    ** Lister never worries about getting rid of them.  If a new
    ** file is selected, getFileName() takes care of the old ones.
    ** Also, when the application is quit, the current file
    ** ref handles are disposed by quitting the application, so
    ** lister has all the cases covered.
    */

    CloseGS(&file->close);
    if (_fileErr = _toolErr) return(_fileErr);
    spreadTheWord(file, 0);

    return(0);
}

/**********************************************************************/

unsigned int    fileErr()
{
    if (_fileErr) ErrorWindow(0, NULL, _fileErr);
    return(_fileErr);
}
